/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Hashtable;
import java.util.List;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskOhasdIntegrity;
import oracle.ops.verification.framework.engine.task.TaskRunLevel;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskOhasdIntegrity {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    static final String LSEP = System.getProperty("line.separator");
    private TaskOhasdIntegrity m_genTask;

    public sTaskOhasdIntegrity(TaskOhasdIntegrity genTask) {
        this.m_genTask = genTask;
    }

    public void checkOhasdConfig(String node, ResultSet resultSet) {
        String[] configFilesArr = new String[]{"/etc/init.d/init.ohasd", "/etc/init.d/ohasd"};
        GlobalExecution globalExec = new GlobalExecution();
        ErrorDescription errDesc = null;
        for (String file : configFilesArr) {
            ResultSet locRset = new ResultSet();
            VerificationUtil.checkFileExistence(new String[]{node}, file, locRset);
            if (locRset.allSuccess()) {
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("2022", false, (Object[])new String[]{file, node}));
            }
            resultSet.uploadResultSet(locRset);
        }
        String cmdSpec = "grep respawn:/etc/init.d/init.ohasd /etc/inittab";
        ResultSet itabResultSet = new ResultSet();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Attempt to run command '" + cmdSpec + "' on node '" + node + "'"));
        }
        Hashtable itabCheckOutput = globalExec.runExeWithOutput(new String[]{node}, cmdSpec, itabResultSet);
        Result result = itabResultSet.getResult(node);
        String etOutput = (String)itabCheckOutput.get(node);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("exectask Output is:'" + etOutput + "'"));
        }
        if (result == null || result.getStatus() == 2) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Failed to execute the exectask command on node '" + node + "'"));
            }
            errDesc = new ErrorDescription("5302", new String[]{node}, s_msgBundle);
            errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cmdSpec);
            ReportUtil.printError(errDesc.getErrorMessage());
            resultSet.addErrorDescription(errDesc);
            resultSet.addResult(node, 2);
        } else {
            String cmdOutput = VerificationUtil.fetchVerificationValue(etOutput);
            String cmdExitStat = VerificationUtil.fetchVerificationResult(etOutput);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Command exit status ='" + cmdExitStat + "'" + LSEP + "Command output ='" + cmdOutput + "'"));
            }
            if (cmdExitStat.equals("0")) {
                String[] outlist = VerificationUtil.getTokensAsArray(cmdOutput, System.getProperty("line.separator"));
                boolean validOhasdEntry = false;
                for (String line : outlist) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("inittab line on node '" + node + "' with 'oahasd' string: '" + line + "'"));
                    }
                    if (!line.startsWith("#")) {
                        validOhasdEntry = true;
                        if (!Trace.isLevelEnabled((int)1)) break;
                        Trace.out((String)("Found inittab entry with 'ohasd' string on node '" + node + "' ;line: '" + line + "'"));
                        break;
                    }
                    if (!Trace.isLevelEnabled((int)1)) continue;
                    Trace.out((String)("Found commented inittab line with 'ohasd'string on node '" + node + "'; line: '" + line + "'"));
                }
                if (!validOhasdEntry) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("/etc/inittab on node '" + node + "' does not contain any valid ohasd entry"));
                    }
                    errDesc = new ErrorDescription("2020", new String[]{node}, s_gMsgBundle);
                    ReportUtil.printError(errDesc.getErrorMessage());
                    resultSet.addErrorDescription(node, errDesc);
                } else {
                    ReportUtil.sureprintln(s_gMsgBundle.getMessage("2023", false, (Object[])new String[]{node}));
                }
            } else if (cmdExitStat.equals("1")) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("/etc/inittab on node '" + node + "' does not contain any oahasd entry"));
                }
                errDesc = new ErrorDescription("2020", new String[]{node}, s_gMsgBundle);
                ReportUtil.printError(errDesc.getErrorMessage());
                resultSet.addErrorDescription(errDesc);
            } else {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Error in executing the command '" + cmdSpec + "' on node '" + node + "'" + LSEP + "command output : '" + cmdOutput + "'"));
                }
                errDesc = new ErrorDescription("5313", new String[]{node}, s_msgBundle);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cmdSpec + LSEP + cmdOutput);
                ReportUtil.printError(errDesc.getErrorMessage());
                resultSet.addErrorDescription(errDesc);
                resultSet.addResult(node, 2);
            }
            List<Integer> supportedRunLevels = VDMUtil.getSupportedRunLevels();
            TaskRunLevel taskRL = new TaskRunLevel(supportedRunLevels);
            taskRL.setNodeList(new String[]{node});
            taskRL.performTask();
            resultSet.uploadResultSet(taskRL.getResultSet());
        }
    }
}

